/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackUser;

public class TransportAuthenticateAction
extends HandledTransportAction<AuthenticateRequest, AuthenticateResponse> {
    private final SecurityContext securityContext;

    @Inject
    public TransportAuthenticateAction(TransportService transportService, ActionFilters actionFilters, SecurityContext securityContext) {
        super("cluster:admin/xpack/security/user/authenticate", transportService, actionFilters, AuthenticateRequest::new);
        this.securityContext = securityContext;
    }

    protected void doExecute(Task task, AuthenticateRequest request, ActionListener<AuthenticateResponse> listener) {
        User authUser;
        Authentication authentication = this.securityContext.getAuthentication();
        User runAsUser = authentication == null ? null : authentication.getUser();
        User user = authUser = runAsUser == null ? null : runAsUser.authenticatedUser();
        if (authUser == null) {
            listener.onFailure((Exception)new ElasticsearchSecurityException("did not find an authenticated user", new Object[0]));
        } else if (SystemUser.is((User)authUser) || XPackUser.is((User)authUser)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + authUser.principal() + "] is internal"));
        } else if (SystemUser.is((User)runAsUser) || XPackUser.is((User)runAsUser)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + runAsUser.principal() + "] is internal"));
        } else {
            listener.onResponse((Object)new AuthenticateResponse(authentication));
        }
    }
}

