/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.MemoizedSupplier;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;

public class BulkShardRequestInterceptor
implements RequestInterceptor {
    private static final Logger logger = LogManager.getLogger(BulkShardRequestInterceptor.class);
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;

    public BulkShardRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState) {
        this.threadContext = threadPool.getThreadContext();
        this.licenseState = licenseState;
    }

    @Override
    public void intercept(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authzEngine, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<Void> listener) {
        boolean shouldIntercept = this.licenseState.isSecurityEnabled();
        MemoizedSupplier licenseChecker = new MemoizedSupplier(() -> this.licenseState.checkFeature(XPackLicenseState.Feature.SECURITY_DLS_FLS));
        if (requestInfo.getRequest() instanceof BulkShardRequest && shouldIntercept) {
            IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
            BulkShardRequest bulkShardRequest = (BulkShardRequest)requestInfo.getRequest();
            for (BulkItemRequest bulkItemRequest : bulkShardRequest.items()) {
                IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(bulkItemRequest.index());
                boolean found = false;
                if (indexAccessControl != null) {
                    boolean fls = indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
                    boolean dls = indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions();
                    if ((fls || dls) && ((Boolean)licenseChecker.get()).booleanValue() && bulkItemRequest.request() instanceof UpdateRequest) {
                        found = true;
                        logger.trace("aborting bulk item update request for index [{}]", (Object)bulkItemRequest.index());
                        bulkItemRequest.abort(bulkItemRequest.index(), (Exception)((Object)new ElasticsearchSecurityException("Can't execute a bulk item request with update requests embedded if field or document level security is enabled", RestStatus.BAD_REQUEST, new Object[0])));
                    }
                }
                if (found) continue;
                logger.trace("intercepted bulk request for index [{}] without any update requests, continuing execution", (Object)bulkItemRequest.index());
            }
        }
        listener.onResponse(null);
    }
}

