/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class SecurityIndexManager
implements ClusterStateListener {
    public static final int INTERNAL_MAIN_INDEX_FORMAT = 6;
    public static final int INTERNAL_TOKENS_INDEX_FORMAT = 7;
    public static final String SECURITY_MAIN_TEMPLATE_7 = "security-index-template-7";
    public static final String SECURITY_TOKENS_TEMPLATE_7 = "security-tokens-index-template-7";
    public static final String SECURITY_VERSION_STRING = "security-version";
    public static final String TEMPLATE_VERSION_VARIABLE = "security.template.version";
    private static final Logger logger = LogManager.getLogger(SecurityIndexManager.class);
    private final String aliasName;
    private final String internalIndexName;
    private final int internalIndexFormat;
    private final Supplier<byte[]> mappingSourceSupplier;
    private final Client client;
    private final List<BiConsumer<State, State>> stateChangeListeners = new CopyOnWriteArrayList<BiConsumer<State, State>>();
    private volatile State indexState;

    public static SecurityIndexManager buildSecurityMainIndexManager(Client client, ClusterService clusterService) {
        return new SecurityIndexManager(client, clusterService, ".security", ".security-7", 6, () -> SecurityIndexManager.readTemplateAsBytes(SECURITY_MAIN_TEMPLATE_7));
    }

    public static SecurityIndexManager buildSecurityTokensIndexManager(Client client, ClusterService clusterService) {
        return new SecurityIndexManager(client, clusterService, ".security-tokens", ".security-tokens-7", 7, () -> SecurityIndexManager.readTemplateAsBytes(SECURITY_TOKENS_TEMPLATE_7));
    }

    private SecurityIndexManager(Client client, ClusterService clusterService, String aliasName, String internalIndexName, int internalIndexFormat, Supplier<byte[]> mappingSourceSupplier) {
        this(client, aliasName, internalIndexName, internalIndexFormat, mappingSourceSupplier, State.UNRECOVERED_STATE);
        clusterService.addListener((ClusterStateListener)this);
    }

    protected SecurityIndexManager(Client client, String aliasName, String internalIndexName, int internalIndexFormat, Supplier<byte[]> mappingSourceSupplier, State indexState) {
        this.aliasName = aliasName;
        this.internalIndexName = internalIndexName;
        this.internalIndexFormat = internalIndexFormat;
        this.mappingSourceSupplier = mappingSourceSupplier;
        this.indexState = indexState;
        this.client = client;
    }

    public SecurityIndexManager freeze() {
        return new SecurityIndexManager(null, this.aliasName, this.internalIndexName, this.internalIndexFormat, this.mappingSourceSupplier, this.indexState);
    }

    public boolean checkMappingVersion(Predicate<Version> requiredVersion) {
        State currentIndexState = this.indexState;
        return currentIndexState.mappingVersion == null || requiredVersion.test(currentIndexState.mappingVersion);
    }

    public String aliasName() {
        return this.aliasName;
    }

    public boolean indexExists() {
        return this.indexState.indexExists();
    }

    public Instant getCreationTime() {
        return this.indexState.creationTime;
    }

    public boolean isIndexUpToDate() {
        return this.indexState.isIndexUpToDate;
    }

    public boolean isAvailable() {
        return this.indexState.indexAvailable;
    }

    public boolean isMappingUpToDate() {
        return this.indexState.mappingUpToDate;
    }

    public boolean isStateRecovered() {
        return this.indexState != State.UNRECOVERED_STATE;
    }

    public ElasticsearchException getUnavailableReason() {
        State localState = this.indexState;
        if (localState.indexAvailable) {
            throw new IllegalStateException("caller must make sure to use a frozen state and check indexAvailable");
        }
        if (localState.indexState == IndexMetadata.State.CLOSE) {
            return new IndexClosedException(new Index(localState.concreteIndexName, "_na_"));
        }
        if (localState.indexExists()) {
            return new UnavailableShardsException(null, "at least one primary shard for the index [" + localState.concreteIndexName + "] is unavailable", new Object[0]);
        }
        return new IndexNotFoundException(localState.concreteIndexName);
    }

    public void addIndexStateListener(BiConsumer<State, State> listener) {
        this.stateChangeListeners.add(listener);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        State newState;
        ClusterHealthStatus indexHealth;
        IndexMetadata.State indexState;
        String concreteIndexName;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            logger.debug("security index manager waiting until state has been recovered");
            return;
        }
        State previousState = this.indexState;
        IndexMetadata indexMetadata = SecurityIndexManager.resolveConcreteIndex(this.aliasName, event.state().metadata());
        Instant creationTime = indexMetadata != null ? Instant.ofEpochMilli(indexMetadata.getCreationDate()) : null;
        boolean isIndexUpToDate = indexMetadata == null || (Integer)IndexMetadata.INDEX_FORMAT_SETTING.get(indexMetadata.getSettings()) == this.internalIndexFormat;
        boolean indexAvailable = this.checkIndexAvailable(event.state());
        boolean mappingIsUpToDate = indexMetadata == null || this.checkIndexMappingUpToDate(event.state());
        Version mappingVersion = this.oldestIndexMappingVersion(event.state());
        String string = concreteIndexName = indexMetadata == null ? this.internalIndexName : indexMetadata.getIndex().getName();
        if (indexMetadata == null) {
            indexState = null;
            indexHealth = null;
        } else if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
            indexState = IndexMetadata.State.CLOSE;
            indexHealth = null;
            logger.warn("Index [{}] is closed. This is likely to prevent security from functioning correctly", (Object)concreteIndexName);
        } else {
            indexState = IndexMetadata.State.OPEN;
            IndexRoutingTable routingTable = event.state().getRoutingTable().index(indexMetadata.getIndex());
            indexHealth = new ClusterIndexHealth(indexMetadata, routingTable).getStatus();
        }
        this.indexState = newState = new State(creationTime, isIndexUpToDate, indexAvailable, mappingIsUpToDate, mappingVersion, concreteIndexName, indexHealth, indexState);
        if (!newState.equals(previousState)) {
            for (BiConsumer<State, State> listener : this.stateChangeListeners) {
                listener.accept(previousState, newState);
            }
        }
    }

    private boolean checkIndexAvailable(ClusterState state) {
        IndexMetadata metadata = SecurityIndexManager.resolveConcreteIndex(this.aliasName, state.metadata());
        if (metadata == null) {
            logger.debug("Index [{}] is not available - no metadata", (Object)this.aliasName);
            return false;
        }
        if (metadata.getState() == IndexMetadata.State.CLOSE) {
            logger.warn("Index [{}] is closed", (Object)this.aliasName);
            return false;
        }
        IndexRoutingTable routingTable = state.routingTable().index(metadata.getIndex());
        if (routingTable == null || !routingTable.allPrimaryShardsActive()) {
            logger.debug("Index [{}] is not yet active", (Object)this.aliasName);
            return false;
        }
        return true;
    }

    public static boolean checkTemplateExistsAndVersionMatches(String templateName, ClusterState state, Logger logger, Predicate<Version> predicate) {
        return TemplateUtils.checkTemplateExistsAndVersionMatches((String)templateName, (String)SECURITY_VERSION_STRING, (ClusterState)state, (Logger)logger, predicate);
    }

    private boolean checkIndexMappingUpToDate(ClusterState clusterState) {
        return this.checkIndexMappingVersionMatches(clusterState, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    private boolean checkIndexMappingVersionMatches(ClusterState clusterState, Predicate<Version> predicate) {
        return SecurityIndexManager.checkIndexMappingVersionMatches(this.aliasName, clusterState, logger, predicate);
    }

    public static boolean checkIndexMappingVersionMatches(String indexName, ClusterState clusterState, Logger logger, Predicate<Version> predicate) {
        return SecurityIndexManager.loadIndexMappingVersions(indexName, clusterState, logger).stream().allMatch(predicate);
    }

    private Version oldestIndexMappingVersion(ClusterState clusterState) {
        Set<Version> versions = SecurityIndexManager.loadIndexMappingVersions(this.aliasName, clusterState, logger);
        return versions.stream().min(Version::compareTo).orElse(null);
    }

    private static Set<Version> loadIndexMappingVersions(String aliasName, ClusterState clusterState, Logger logger) {
        HashSet<Version> versions = new HashSet<Version>();
        IndexMetadata indexMetadata = SecurityIndexManager.resolveConcreteIndex(aliasName, clusterState.metadata());
        if (indexMetadata != null) {
            for (Object object : indexMetadata.getMappings().values().toArray()) {
                MappingMetadata mappingMetadata = (MappingMetadata)object;
                if (mappingMetadata.type().equals("_default_")) continue;
                versions.add(SecurityIndexManager.readMappingVersion(aliasName, mappingMetadata, logger));
            }
        }
        return versions;
    }

    private static IndexMetadata resolveConcreteIndex(String indexOrAliasName, Metadata metadata) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexOrAliasName);
        if (indexAbstraction != null) {
            List indices = indexAbstraction.getIndices();
            if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX && indices.size() > 1) {
                throw new IllegalStateException("Alias [" + indexOrAliasName + "] points to more than one index: " + indices.stream().map(imd -> imd.getIndex().getName()).collect(Collectors.toList()));
            }
            return (IndexMetadata)indices.get(0);
        }
        return null;
    }

    private static Version readMappingVersion(String indexName, MappingMetadata mappingMetadata, Logger logger) {
        try {
            Map meta = (Map)mappingMetadata.sourceAsMap().get("_meta");
            if (meta == null) {
                logger.info("Missing _meta field in mapping [{}] of index [{}]", (Object)mappingMetadata.type(), (Object)indexName);
                throw new IllegalStateException("Cannot read security-version string in index " + indexName);
            }
            return Version.fromString((String)((String)meta.get(SECURITY_VERSION_STRING)));
        }
        catch (ElasticsearchParseException e) {
            logger.error((Message)new ParameterizedMessage("Cannot parse the mapping for index [{}]", (Object)indexName), (Throwable)e);
            throw new ElasticsearchException("Cannot parse the mapping for index [{}]", (Throwable)e, new Object[]{indexName});
        }
    }

    public void checkIndexVersionThenExecute(Consumer<Exception> consumer, Runnable andThen) {
        State indexState = this.indexState;
        if (indexState.indexExists() && !indexState.isIndexUpToDate) {
            consumer.accept(new IllegalStateException("Index [" + indexState.concreteIndexName + "] is not on the current version. Security features relying on the index will not be available until the upgrade API is run on the index"));
        } else {
            andThen.run();
        }
    }

    public void prepareIndexIfNeededThenExecute(final Consumer<Exception> consumer, final Runnable andThen) {
        State indexState = this.indexState;
        try {
            if (indexState == State.UNRECOVERED_STATE) {
                throw new ElasticsearchStatusException("Cluster state has not been recovered yet, cannot write to the [" + indexState.concreteIndexName + "] index", RestStatus.SERVICE_UNAVAILABLE, new Object[0]);
            }
            if (indexState.indexExists() && !indexState.isIndexUpToDate) {
                throw new IllegalStateException("Index [" + indexState.concreteIndexName + "] is not on the current version.Security features relying on the index will not be available until the upgrade API is run on the index");
            }
            if (!indexState.indexExists()) {
                assert (indexState.concreteIndexName != null);
                logger.info("security index does not exist. Creating [{}] with alias [{}]", (Object)indexState.concreteIndexName, (Object)this.aliasName);
                byte[] mappingSource = this.mappingSourceSupplier.get();
                Tuple<String, Settings> mappingAndSettings = SecurityIndexManager.parseMappingAndSettingsFromTemplateBytes(mappingSource);
                CreateIndexRequest request = new CreateIndexRequest(indexState.concreteIndexName).alias(new Alias(this.aliasName)).mapping("_doc", (String)mappingAndSettings.v1(), XContentType.JSON).waitForActiveShards(ActiveShardCount.ALL).settings((Settings)mappingAndSettings.v2());
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)new ActionListener<CreateIndexResponse>(){

                    public void onResponse(CreateIndexResponse createIndexResponse) {
                        if (createIndexResponse.isAcknowledged()) {
                            andThen.run();
                        } else {
                            consumer.accept(new ElasticsearchException("Failed to create security index", new Object[0]));
                        }
                    }

                    public void onFailure(Exception e) {
                        Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                        if (cause instanceof ResourceAlreadyExistsException) {
                            andThen.run();
                        } else {
                            consumer.accept(e);
                        }
                    }
                }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).create(arg_0, arg_1));
            } else if (!indexState.mappingUpToDate) {
                logger.info("Index [{}] (alias [{}]) is not up to date. Updating mapping", (Object)indexState.concreteIndexName, (Object)this.aliasName);
                byte[] mappingSource = this.mappingSourceSupplier.get();
                Tuple<String, Settings> mappingAndSettings = SecurityIndexManager.parseMappingAndSettingsFromTemplateBytes(mappingSource);
                PutMappingRequest request = new PutMappingRequest(new String[]{indexState.concreteIndexName}).source((String)mappingAndSettings.v1(), XContentType.JSON).type("_doc");
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)ActionListener.wrap(putMappingResponse -> {
                    if (putMappingResponse.isAcknowledged()) {
                        andThen.run();
                    } else {
                        consumer.accept(new IllegalStateException("put mapping request was not acknowledged"));
                    }
                }, consumer), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putMapping(arg_0, arg_1));
            } else {
                andThen.run();
            }
        }
        catch (Exception e) {
            consumer.accept(e);
        }
    }

    public static boolean isMoveFromRedToNonRed(State previousState, State currentState) {
        return (previousState.indexHealth == null || previousState.indexHealth == ClusterHealthStatus.RED) && currentState.indexHealth != null && currentState.indexHealth != ClusterHealthStatus.RED;
    }

    public static boolean isIndexDeleted(State previousState, State currentState) {
        return previousState.indexHealth != null && currentState.indexHealth == null;
    }

    private static byte[] readTemplateAsBytes(String templateName) {
        return TemplateUtils.loadTemplate((String)("/" + templateName + ".json"), (String)Version.CURRENT.toString(), (String)TEMPLATE_VERSION_VARIABLE).getBytes(StandardCharsets.UTF_8);
    }

    private static Tuple<String, Settings> parseMappingAndSettingsFromTemplateBytes(byte[] template) throws IOException {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest("name_is_not_important").source(template, XContentType.JSON);
        String mappingSource = (String)request.mappings().get("_doc");
        try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, mappingSource);){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
            XContentParserUtils.ensureFieldName((XContentParser)parser, (XContentParser.Token)parser.nextToken(), (String)"_doc");
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.generator().copyCurrentStructure(parser);
            Tuple tuple = new Tuple((Object)Strings.toString((XContentBuilder)builder), (Object)request.settings());
            return tuple;
        }
    }

    public static class State {
        public static final State UNRECOVERED_STATE = new State(null, false, false, false, null, null, null, null);
        public final Instant creationTime;
        public final boolean isIndexUpToDate;
        public final boolean indexAvailable;
        public final boolean mappingUpToDate;
        public final Version mappingVersion;
        public final String concreteIndexName;
        public final ClusterHealthStatus indexHealth;
        public final IndexMetadata.State indexState;

        public State(Instant creationTime, boolean isIndexUpToDate, boolean indexAvailable, boolean mappingUpToDate, Version mappingVersion, String concreteIndexName, ClusterHealthStatus indexHealth, IndexMetadata.State indexState) {
            this.creationTime = creationTime;
            this.isIndexUpToDate = isIndexUpToDate;
            this.indexAvailable = indexAvailable;
            this.mappingUpToDate = mappingUpToDate;
            this.mappingVersion = mappingVersion;
            this.concreteIndexName = concreteIndexName;
            this.indexHealth = indexHealth;
            this.indexState = indexState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return Objects.equals(this.creationTime, state.creationTime) && this.isIndexUpToDate == state.isIndexUpToDate && this.indexAvailable == state.indexAvailable && this.mappingUpToDate == state.mappingUpToDate && Objects.equals(this.mappingVersion, state.mappingVersion) && Objects.equals(this.concreteIndexName, state.concreteIndexName) && this.indexHealth == state.indexHealth && this.indexState == state.indexState;
        }

        public boolean indexExists() {
            return this.creationTime != null;
        }

        public int hashCode() {
            return Objects.hash(this.creationTime, this.isIndexUpToDate, this.indexAvailable, this.mappingUpToDate, this.mappingVersion, this.concreteIndexName, this.indexHealth);
        }
    }
}

